# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['auto_everything', 'auto_everything.x11']

package_data = \
{'': ['*'], 'auto_everything.x11': ['example/*']}

install_requires = \
['fire==0.5.0', 'psutil==5.9.4']

entry_points = \
{'console_scripts': ['auto_everything = '
                     'auto_everything._command_line_interface:main',
                     'hi = auto_everything._command_line_interface:_hi']}

setup_kwargs = {
    'name': 'auto-everything',
    'version': '3.20',
    'description': 'do automate things on Linux',
    'long_description': '# auto_everything\n\nLinux automation\n\n#### Help Wanted\n\nI lost my job for almost a year. If you wish to see me alive, please buy me some food:\n\n* Paypal: https://paypal.me/yingshaoxo\n* Patron: https://www.patreon.com/bePatron?u=45200693\n\n<!-- [<img src="https://github.com/yingshaoxo/yingshaoxo/raw/master/become_a_patron_button.png" width="200">](https://www.patreon.com/bePatron?u=45200693) -->\n\n#### Installation (For Python >= 3.10)\n\n```bash\ncurl -sSL https://install.python-poetry.org | python3\npoetry add auto_everything\n\nor\n\nsudo pip3 install auto_everything\n```\n\n> Full Installation: `poetry add auto_everything --extras all`\n\n#### Installation (For 3.5 <= Python < 3.10)\n\n```bash\npoetry add auto_everything==3.9\n\nor\n\nsudo pip3 install auto_everything==3.9\n```\n\n#### Magic\n\n```bash\npython3 -m auto_everything\n```\n\nor\n\n```bash\ncurl -sSL https://github.com/yingshaoxo/auto_everything/raw/master/env_setup.sh | bash\n\nwget -O - https://github.com/yingshaoxo/auto_everything/raw/master/example/install_YouCompleteMe.py | python3\n```\n\n#### Docs\n\nhttps://yingshaoxo.github.io/auto_everything\n\n---\n\n## Basic API\n\n#### Import\n\n```python\nfrom auto_everything.terminal import Terminal\nt = Terminal()\n```\n\n#### Run a command and get reply\n\n```python\nreply = t.run_command(\'uname -a\')\nprint(reply)\n```\n\n#### Run commands and get direct screen output\n\n```python\ncommands = """\nsudo apt update\nuname -a\n"""\nt.run(commands)\n```\n\n#### Run a program\n\n```python\nt.run_program(\'firefox\')\n```\n\n#### Run a python script\n\n```python\nt.run_py(\'your_file.py\')\n```\n\n#### Run a bash script\n\n```python\nt.run_sh(\'your_file.sh\')\n```\n\n#### Detect if a program or script is running\n\n```python\nstatus = t.is_running(\'terminal\')\nprint(status)\n```\n\n#### Kill it\n\n```python\nt.kill(\'terminal\')\n```\n\n---\n\n## For simplifying python development\n\n#### Import\n\n```python\nfrom auto_everything.python import Python\npy = Python()\n```\n\n#### Turn `Python Class` into a `Command Line Program`\n\n```python\npy.fire(your_class_name)\n```\n\n#### Make it `global executable`:\n\n```python\npy.make_it_global_runnable(executable_name="Tools")\n```\n\n#### Example\n\nLet\'s assume you have a file named `Tools.py`:\n\n```python\nfrom auto_everything.base import Python\npy = Python()\n\nclass Tools():\n    def push(self, comment):\n        t.run(\'git add .\')\n        t.run(\'git commit -m "{}"\'.format(comment))\n        t.run(\'git push origin\')\n\n    def pull(self):\n        t.run("""\ngit fetch --all\ngit reset --hard origin/master\n""")\n\n    def undo(self):\n        t.run("""\ngit reset --mixed HEAD~1\n""")\n\n    def reset(self):\n        t.run("""\ngit reset --hard HEAD^\n""")\n\n    def hi(self):\n        print("Hi, Python!")\n\npy.fire(Tools)\npy.make_it_global_runnable(executable_name="MyTools")\n```\n\nAfter the first running of this script by `python3 Tools.py hi`, you would be able to use `MyTools` to run this script at anywhere within your machine:\n\n```bash\nyingshaoxo@pop-os:~$ MyTools hi\nHi, Python!\n\n```\n\n---\n\n## For simplifying general `server and client` development\n\n\n#### Define YRPC Protocols\n\n```grpc\nservice Greeter {\n    rpc say_hello (hello_request) returns (HelloReply);\n}\n\nenum UserStatus {\n    OFFLINE = 0;\n    ONLINE = 1;\n}\n\nmessage hello_request {\n   string name = 1;\n   UserStatus user_status = 2;\n   repeated UserStatus user_status_list = 3;\n}\n\nmessage HelloReply {\n    string message = 1;\n}\n```\n\n#### Generate `Python, Flutter, Typescript` code\n\n```python\nfrom auto_everything.develop import YRPC\nyrpc = YRPC()\n\nfor language in ["python", "dart", "typescript"]:\n    yrpc.generate_code(\n        which_language=language,\n        input_folder="/home/yingshaoxo/CS/protocol_test/protocols",\n        input_files=["english.proto"],\n        output_folder="/Users/yingshaoxo/CS/protocol_test/generated_yrpc"\n    )\n```\n\n> Here, we only use python to do the server part job.\n\n#### Then, you can use it like this:\n\n```python\nfrom generated_yrpc.english_rpc import *\n\nclass NewService(Service_english):\n    async def say_hello(self, item: hello_request) -> HelloReply:\n        reply = HelloReply()\n        reply.message = item.name\n        return reply\n\nservice_instance = NewService()\nrun(service_instance, port="6060")\n```\n\n```dart\nvoid main() async {\n  var client = Client_english(\n    service_url: "http://127.0.0.1:6060",\n    error_handle_function: (error_message) {\n      print(error_message);\n    },\n  );\n\n  var result = await client.say_hello(\n    item: hello_request(name: "yingshaoxo")\n  );\n  if (result != null) {\n    print(result);\n  }\n}\n```\n\n___\n\n## Others\n\n#### Simpler IO\n\n```python\nfrom auto_everything.base import IO\nio = IO()\n\nio.write("hi.txt", "Hello, world!")\nprint(io.read("hi.txt"))\n\nio.append("hi.txt", "\\n\\nI\'m yingshaoxo.")\nprint(io.read("hi.txt"))\n```\n\n#### Quick File Operation\n\n```python\nfrom auto_everything.disk import Disk\nfrom pprint import pprint\ndisk = Disk()\n\nfiles = disk.get_files(folder=".", type_limiter=[".mp4"])\nfiles = disk.sort_files_by_time(files)\npprint(files)\n```\n\n#### Easy Store\n\n```python\nfrom auto_everything.disk import Store\nstore = Store("test")\n\nstore.set("author", "yingshaoxo")\nstore.delete("author")\nstore.set("author", {"email": "yingshaoxo@gmail.com", "name": "yingshaoxo"})\nprint(store.get_items())\n\nprint(store.has_key("author"))\nprint(store.get("author", default_value=""))\nprint(store.get("whatever", default_value="alsjdasdfasdfsakfla"))\n\nstore.reset()\nprint(store.get_items())\n```\n\n#### Encryption and Decryption\n\n```python\nencryption_and_decryption = EncryptionAndDecryption()\n\na_dict = encryption_and_decryption.get_secret_alphabet_dict("hello, world")\n\na_sentence = "I\'m yingshaoxo."\n\nencrypted_sentence = encryption_and_decryption.encode_message(a_secret_dict=a_dict, message=a_sentence)\nprint()\nprint(encrypted_sentence)\n> B\'i ybjdqahkxk.\n\ndecrypted_sentence = encryption_and_decryption.decode_message(a_secret_dict=a_dict, message=encrypted_sentence)\nprint(decrypted_sentence)\n> I\'m yingshaoxo.\n```\n\n#### JWT Tool (Json-Web-Token Tool) \n```python\njwt_tool  = JWT_Tool()\n\nsecret = "I\'m going to tell you a secret: yingshaoxo is the best."\n\na_jwt_string = jwt_tool.my_jwt_encode(data={"name": "yingshaoxo"}, a_secret_string_for_integrity_verifying=secret)\nprint(a_jwt_string)\n> eyJhbGciOiAiTUQ1IiwgInR5cCI6ICJKV1QifQ==.eyJuYW1lIjogInlpbmdzaGFveG8ifQ==.583085987ba46636662dc71ca6227c0a\n\noriginal_dict = jwt_tool.my_jwt_decode(jwt_string=a_jwt_string, a_secret_string_for_integrity_verifying=secret)\nprint(original_dict)\n> {\'name\': \'yingshaoxo\'}\n\nfake_jwt_string = "aaaaaa.bbbbbb.abcdefg"\noriginal_dict = jwt_tool.my_jwt_decode(jwt_string=fake_jwt_string, a_secret_string_for_integrity_verifying=secret)\nprint(original_dict)\n> None\n```\n\n#### Web automation\n\n```python\nfrom auto_everything.web import Selenium\nfrom time import sleep\n\nmy_selenium = Selenium("https://www.google.com", headless=False)\nd = my_selenium.driver\n\n# get input box\nxpath = \'//*[@id="lst-ib"]\'\nelements = my_selenium.wait_until_exists(xpath)\n\n# text inputing\nelements[0].send_keys(\'\\b\' * 20, "yingshaoxo")\n\n# click search button\nelements = my_selenium.wait_until_exists(\'//input[@value="Google Search"]\')\nif len(elements):\n    elements[0].click() # d.execute_script("arguments[0].click();", elements[0])\n\n# exit\nsleep(30)\nd.quit()\n```\n\n',
    'author': 'yingshaoxo',
    'author_email': 'yingshaoxo@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
