# PypeIt

The Python Spectroscopic Data Reduction Pipeline.  For
documentation visit:

http://pypeit.readthedocs.io

and/or see our HOWTO:

https://tinyurl.com/pypeit-howto

and/or join our PypeIt Users Slack 
(the invite is recorded in this Issue:
https://github.com/pypeit/PypeIt/issues/676)

# Please cite:


[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3743493.svg)](https://doi.org/10.5281/zenodo.3743493)


# Contribute

We encourage anyone to help us develop the `PypeIt` code base to better
suit your needs and to improve its algorithms. If you do so, please
follow our [Development
Guidlines](https://pypeit.readthedocs.io/en/latest/development.html)

In particular, please note our [Code of
Conduct](https://pypeit.readthedocs.io/en/latest/codeconduct.html).


# Instruments Served
* Gemini/GNIRS
* Gemini/GMOS 
* Gemini/FLAMINGOS 2 
* Lick/Kast 
* Magellan/MagE
* Magellan/Fire
* MDM/OSMOS
* Keck/DEIMOS (600ZD, 830G, 1200G)
* Keck/LRIS 
* Keck/MOSFIRE  (J and Y gratings tested)
* Keck/NIRES
* Keck/NIRSPEC (low-dispersion)
* LBT/Luci-I, Luci-II
* LBT/MODS (beta)
* Lick/APF (planned)
* NOT/ALFOSC (grism4)
* VLT/X-Shooter
* VLT/FORS2  (300I, 300V)
* WHT/ISIS

# Requirements

(see `pypeit/requirements.txt`)

* python
* numpy
* scipy
* matplotlib
* astropy
* ginga
* h5py
* future
* PyYAML
* linetools
* IPython
* scikit-learn
* configobj


# License (BSD-3)

(see `LICENSE.rst`)

Copyright (c) 2018-2019, PypeIt Developers All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

 - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

 - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

 - Neither the name of the Astropy Team nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


