# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['typer_cli']

package_data = \
{'': ['*']}

install_requires = \
['colorama>=0.4.3,<0.5.0',
 'importlib_metadata>=1.5,<2.0',
 'shellingham>=1.3.2,<2.0.0',
 'typer>=0.1.0,<0.2.0']

entry_points = \
{'console_scripts': ['typer = typer_cli.main:main']}

setup_kwargs = {
    'name': 'typer-cli',
    'version': '0.0.7',
    'description': 'Run Typer scripts with completion, without having to create a package, using Typer CLI.',
    'long_description': '# Typer CLI\n\n<p align="center">\n    <em>Run <strong>Typer</strong> scripts with completion, without having to create a package, using <strong>Typer CLI</strong>.</em>\n</p>\n<p align="center">\n<a href="https://travis-ci.com/tiangolo/typer-cli" target="_blank">\n    <img src="https://travis-ci.com/tiangolo/typer-cli.svg?branch=master" alt="Build Status">\n</a>\n<a href="https://codecov.io/gh/tiangolo/typer-cli" target="_blank">\n    <img src="https://codecov.io/gh/tiangolo/typer-cli/branch/master/graph/badge.svg" alt="Coverage">\n</a>\n<a href="https://pypi.org/project/typer-cli" target="_blank">\n    <img src="https://badge.fury.io/py/typer-cli.svg" alt="Package version">\n</a>\n</p>\n\nThere is an optional utility tool called **Typer CLI**, additional to **Typer** itself.\n\nIt\'s main feature is to provide ✨ completion ✨ in the Terminal for your own small programs built with **Typer**.\n\n...without you having to create a complete installable Python package.\n\nIt\'s probably most useful if you have a small custom Python script using **Typer** (maybe as part of some project), for some small tasks, and it\'s not complex/important enough to create a whole installable Python package for it (something to be installed with `pip`).\n\nIn that case, you can install **Typer CLI**, and run your program with the `typer` command in your Terminal, and it will provide completion for your script.\n\nYou can also use **Typer CLI** to generate Markdown documentation for your own **Typer** programs 📝.\n\n---\n\n**Documentation**: <a href="https://typer.tiangolo.com/typer-cli/" target="_blank">https://typer.tiangolo.com/typer-cli/</a>\n\n**Source Code for Typer CLI**: <a href="https://github.com/tiangolo/typer-cli" target="_blank">https://github.com/tiangolo/typer-cli</a>\n\n---\n\n## **Typer** or **Typer CLI**\n\n**Typer** is a library for building CLIs (Command Line Interface applications).\n\nYou use **Typer** in your Python scripts. Like in:\n\n```Python\nimport typer\n\n\ndef main():\n    typer.echo("Hello World")\n\n\nif __name__ == "__main__":\n    typer.run(main)\n```\n\n**Typer CLI** is a command line application to run simple programs created with **Typer**, with completion in your terminal 🚀.\n\nYou use **Typer CLI** in your terminal, to run your scripts (as an alternative to calling `python` directly). Like in:\n\n<div class="termy">\n\n```console\n$ typer my_script.py run\n\nHello World\n```\n\n</div>\n\nBut you never import anything from **Typer CLI** in your own scripts.\n\n## Usage\n\n### Install\n\nInstall **Typer CLI**:\n\n<div class="termy">\n\n```console\n$ python -m pip install typer-cli\n---> 100%\nSuccessfully installed typer-cli\n```\n\n</div>\n\nThat creates a `typer` command you can call in your terminal, much like `python`, `git`, or `echo`.\n\nYou can then install completion for it:\n\n<div class="termy">\n\n```console\n$ typer --install-completion\n\nzsh completion installed in /home/user/.bashrc.\nCompletion will take effect once you restart the terminal.\n```\n\n</div>\n\n### Sample script\n\nLet\'s say you have a script that uses **Typer** in `my_custom_script.py`:\n\n```Python\nimport typer\n\napp = typer.Typer()\n\n\n@app.command()\ndef hello(name: str = None):\n    if name:\n        typer.echo(f"Hello {name}")\n    else:\n        typer.echo("Hello World!")\n\n\n@app.command()\ndef bye(name: str = None):\n    if name:\n        typer.echo(f"Bye {name}")\n    else:\n        typer.echo("Goodbye!")\n\n\nif __name__ == "__main__":\n    app()\n```\n\nFor it to work, you would also install **Typer**:\n\n<div class="termy">\n\n```console\n$ python -m pip install typer\n---> 100%\nSuccessfully installed typer\n```\n\n</div>\n\n### Run with Python\n\nThen you could run your script with normal Python:\n\n<div class="termy">\n\n```console\n$ python my_custom_script.py hello\n\nHello World!\n\n$ python my_custom_script.py hello --name Camila\n\nHello Camila!\n\n$ python my_custom_script.py bye --name Camila\n\nBye Camila\n```\n\n</div>\n\nThere\'s nothing wrong with using Python directly to run it. And, in fact, if some other code or program uses your script, that would probably be the best way to do it.\n\n⛔️ But in your terminal, you won\'t get completion when hitting <kbd>TAB</kbd> for any of the subcommands or options, like `hello`, `bye`, and `--name`.\n\n### Run with **Typer CLI**\n\nHere\'s where **Typer CLI** is useful.\n\nYou can also run the same script with the `typer` command you get after installing `typer-cli`:\n\n<div class="termy">\n\n```console\n$ typer my_custom_script.py run hello\n\nHello World!\n\n$ typer my_custom_script.py run hello --name Camila\n\nHello Camila!\n\n$ typer my_custom_script.py run bye --name Camila\n\nBye Camila\n```\n\n</div>\n\n* Instead of using `python` directly you use the `typer` command.\n* After the name of the file, add the subcommand `run`.\n\n✔️ If you installed completion for **Typer CLI** (for the `typer` command) as described above, when you hit <kbd>TAB</kbd> you will have ✨ completion for everything ✨, including all the subcommands and options of your script, like `hello`, `bye`, and `--name` 🚀.\n\n## If main\n\nBecause **Typer CLI** won\'t use the block with:\n\n```Python\nif __name__ == "__main__":\n    app()\n```\n\n...you can also remove it if you are calling that script only with **Typer CLI** (using the `typer` command).\n\n## Run other files\n\n**Typer CLI** can run any script with **Typer**, but the script doesn\'t even have to use **Typer** at all.\n\n**Typer CLI** could even run a file with a function that could be used with `typer.run()`, even if the script doesn\'t use `typer.run()` or anything else.\n\nFor example, a file `main.py` like this will still work:\n\n```Python\ndef main(name: str = "World"):\n    """\n    Say hi to someone, by default to the World.\n    """\n    print(f"Hello {name}")\n```\n\nThen you can call it with:\n\n<div class="termy">\n\n```console\n$ typer main.py run --help\nUsage: typer run [OPTIONS]\n\n  Say hi to someone, by default to the World.\n\nOptions:\n  --name TEXT\n  --help       Show this message and exit.\n\n$ typer main.py run --name Camila\n\nHello Camila\n```\n\n</div>\n\nAnd it will also have completion for things like the `--name` *CLI Option*.\n\n## Run a package or module\n\nInstead of a file path you can pass a module (possibly in a package) to import.\n\nFor example:\n\n<div class="termy">\n\n```console\n$ typer my_package.main run --help\nUsage: typer run [OPTIONS]\n\nOptions:\n  --name TEXT\n  --help       Show this message and exit.\n\n$ typer my_package.main run --name Camila\n\nHello Camila\n```\n\n</div>\n\n## Options\n\nYou can specify one of the following **CLI options**:\n\n* `--app`: the name of the variable with a `Typer()` object to run as the main app.\n* `--func`: the name of the variable with a function that would be used with `typer.run()`.\n\n### Defaults\n\nWhen your run a script with the **Typer CLI** (the `typer` command) it will use the app from the following priority:\n\n* An app object from the `--app` *CLI Option*.\n* A function to convert to a **Typer** app from `--func` *CLI Option* (like when using `typer.run()`).\n* A **Typer** app in a variable with a name of `app`, `cli`, or `main`.\n* The first **Typer** app available in the file, with any name.\n* A function in a variable with a name of `main`, `cli`, or `app`.\n* The first function in the file, with any name.\n\n## Generate docs\n\n**Typer CLI** can also generate Markdown documentation for your **Typer** application.\n\n### Sample script with docs\n\nFor example, you could have a script like:\n\n```Python\nimport typer\n\napp = typer.Typer(help="Awesome CLI user manager.")\n\n\n@app.command()\ndef create(username: str):\n    """\n    Create a new user with USERNAME.\n    """\n    typer.echo(f"Creating user: {username}")\n\n\n@app.command()\ndef delete(\n    username: str,\n    force: bool = typer.Option(\n        ...,\n        prompt="Are you sure you want to delete the user?",\n        help="Force deletion without confirmation.",\n    ),\n):\n    """\n    Delete a user with USERNAME.\n\n    If --force is not used, will ask for confirmation.\n    """\n    if force:\n        typer.echo(f"Deleting user: {username}")\n    else:\n        typer.echo("Operation cancelled")\n\n\n@app.command()\ndef delete_all(\n    force: bool = typer.Option(\n        ...,\n        prompt="Are you sure you want to delete ALL users?",\n        help="Force deletion without confirmation.",\n    )\n):\n    """\n    Delete ALL users in the database.\n\n    If --force is not used, will ask for confirmation.\n    """\n    if force:\n        typer.echo("Deleting all users")\n    else:\n        typer.echo("Operation cancelled")\n\n\n@app.command()\ndef init():\n    """\n    Initialize the users database.\n    """\n    typer.echo("Initializing user database")\n\n\nif __name__ == "__main__":\n    app()\n```\n\n### Generate docs with Typer CLI\n\nThen you could generate docs for it with **Typer CLI**.\n\nYou can use the subcommand `utils`.\n\nAnd then the subcommand `docs`.\n\n<div class="termy">\n\n```console\n$ typer some_script.py utils docs\n```\n\n</div>\n\n**Options**:\n\n* `--name TEXT`: The name of the CLI program to use in docs.\n* `--output FILE`: An output file to write docs to, like README.md.\n\nFor example:\n\n<div class="termy">\n\n```console\n$ typer my_package.main utils docs --name awesome-cli --output README.md\n\nDocs saved to: README.md\n```\n\n</div>\n\n### Sample docs output\n\nFor example, for the previous script, the generated docs would look like:\n\n---\n\n## `awesome-cli`\n\nAwesome CLI user manager.\n\n**Usage**:\n\n```console\n$ awesome-cli [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `create`: Create a new user with USERNAME.\n* `delete`: Delete a user with USERNAME.\n* `delete-all`: Delete ALL users in the database.\n* `init`: Initialize the users database.\n\n## `awesome-cli create`\n\nCreate a new user with USERNAME.\n\n**Usage**:\n\n```console\n$ awesome-cli create [OPTIONS] USERNAME\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `awesome-cli delete`\n\nDelete a user with USERNAME.\n\nIf --force is not used, will ask for confirmation.\n\n**Usage**:\n\n```console\n$ awesome-cli delete [OPTIONS] USERNAME\n```\n\n**Options**:\n\n* `--force / --no-force`: Force deletion without confirmation.  [required]\n* `--help`: Show this message and exit.\n\n## `awesome-cli delete-all`\n\nDelete ALL users in the database.\n\nIf --force is not used, will ask for confirmation.\n\n**Usage**:\n\n```console\n$ awesome-cli delete-all [OPTIONS]\n```\n\n**Options**:\n\n* `--force / --no-force`: Force deletion without confirmation.  [required]\n* `--help`: Show this message and exit.\n\n## `awesome-cli init`\n\nInitialize the users database.\n\n**Usage**:\n\n```console\n$ awesome-cli init [OPTIONS]\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n---\n\n## License\n\n**Typer CLI**, the same as **Typer**, is licensed under the terms of the MIT license.\n',
    'author': 'Sebastián Ramírez',
    'author_email': 'tiangolo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tiangolo/typer-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
