/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.QuietReport;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.LinkedResource;
import com.adobe.epubcheck.opf.LinkedResources;
import com.adobe.epubcheck.opf.MetadataSet;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ResourceCollection;
import com.adobe.epubcheck.opf.ResourceCollections;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.vocab.AccessibilityVocab;
import com.adobe.epubcheck.vocab.DCMESVocab;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.ForeignVocabs;
import com.adobe.epubcheck.vocab.MediaOverlaysVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.RenditionVocabs;
import com.adobe.epubcheck.vocab.ScriptedCompVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OPFHandler30
extends OPFHandler {
    private static final Map<String, Vocab> RESERVED_VOCABS = new ImmutableMap.Builder().put((Object)"dcterms", (Object)ForeignVocabs.DCTERMS_VOCAB).put((Object)"marc", (Object)ForeignVocabs.MARC_VOCAB).put((Object)"onix", (Object)ForeignVocabs.ONIX_VOCAB).put((Object)"schema", (Object)ForeignVocabs.SCHEMA_VOCAB).put((Object)"xsd", (Object)ForeignVocabs.XSD_VOCAB).build();
    private static final Map<String, Vocab> RESERVED_META_VOCABS = new ImmutableMap.Builder().put((Object)"", PackageVocabs.META_VOCAB).put((Object)"a11y", AccessibilityVocab.META_VOCAB).put((Object)"media", MediaOverlaysVocab.VOCAB).put((Object)"rendition", RenditionVocabs.META_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_ITEM_VOCABS = new ImmutableMap.Builder().put((Object)"", PackageVocabs.ITEM_VOCAB).put((Object)"media", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"rendition", (Object)VocabUtil.EMPTY_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_ITEMREF_VOCABS = new ImmutableMap.Builder().put((Object)"", PackageVocabs.ITEMREF_VOCAB).put((Object)"media", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"rendition", RenditionVocabs.ITEMREF_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_LINKREL_VOCABS = new ImmutableMap.Builder().put((Object)"", PackageVocabs.LINKREL_VOCAB).put((Object)"a11y", AccessibilityVocab.LINKREL_VOCAB).put((Object)"media", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"rendition", (Object)VocabUtil.EMPTY_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> RESERVED_LINK_VOCABS = new ImmutableMap.Builder().put((Object)"", PackageVocabs.LINK_VOCAB).put((Object)"a11y", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"media", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"rendition", (Object)VocabUtil.EMPTY_VOCAB).putAll(RESERVED_VOCABS).build();
    private static final Map<String, Vocab> KNOWN_VOCAB_URIS = new ImmutableMap.Builder().put((Object)"http://purl.org/dc/terms/", (Object)ForeignVocabs.DCTERMS_VOCAB).put((Object)"http://id.loc.gov/vocabulary/", (Object)ForeignVocabs.MARC_VOCAB).put((Object)"http://www.editeur.org/ONIX/book/codelists/current.html#", (Object)ForeignVocabs.ONIX_VOCAB).put((Object)"http://schema.org/", (Object)ForeignVocabs.SCHEMA_VOCAB).put((Object)"http://www.w3.org/2001/XMLSchema#", (Object)ForeignVocabs.XSD_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_META_VOCAB_URIS = new ImmutableMap.Builder().putAll(KNOWN_VOCAB_URIS).put((Object)"http://www.idpf.org/epub/vocab/package/a11y/#", AccessibilityVocab.META_VOCAB).put((Object)"http://www.idpf.org/epub/vocab/overlays/#", MediaOverlaysVocab.VOCAB).put((Object)"http://www.idpf.org/vocab/rendition/#", RenditionVocabs.META_VOCAB).put((Object)"http://idpf.org/epub/vocab/sc/#", ScriptedCompVocab.VOCAB).build();
    private static final Map<String, Vocab> KNOWN_ITEM_VOCAB_URIS = new ImmutableMap.Builder().putAll(KNOWN_VOCAB_URIS).put((Object)"http://www.idpf.org/epub/vocab/package/a11y/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/epub/vocab/overlays/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/vocab/rendition/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://idpf.org/epub/vocab/sc/#", (Object)VocabUtil.EMPTY_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_ITEMREF_VOCAB_URIS = new ImmutableMap.Builder().putAll(KNOWN_VOCAB_URIS).put((Object)"http://www.idpf.org/epub/vocab/package/a11y/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/epub/vocab/overlays/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/vocab/rendition/#", RenditionVocabs.ITEMREF_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_LINK_VOCAB_URIS = new ImmutableMap.Builder().putAll(KNOWN_VOCAB_URIS).put((Object)"http://www.idpf.org/epub/vocab/package/a11y/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/epub/vocab/overlays/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/vocab/rendition/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://idpf.org/epub/vocab/sc/#", (Object)VocabUtil.EMPTY_VOCAB).build();
    private static final Map<String, Vocab> KNOWN_LINKREL_VOCAB_URIS = new ImmutableMap.Builder().putAll(KNOWN_VOCAB_URIS).put((Object)"http://www.idpf.org/epub/vocab/package/a11y/#", AccessibilityVocab.LINKREL_VOCAB).put((Object)"http://www.idpf.org/epub/vocab/overlays/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://www.idpf.org/vocab/rendition/#", (Object)VocabUtil.EMPTY_VOCAB).put((Object)"http://idpf.org/epub/vocab/sc/#", (Object)VocabUtil.EMPTY_VOCAB).build();
    private static final Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of((Object)"http://idpf.org/epub/vocab/package/item/#", (Object)"http://idpf.org/epub/vocab/package/itemref/#", (Object)"http://idpf.org/epub/vocab/package/meta/#", (Object)"http://idpf.org/epub/vocab/package/link/#");
    private static final Splitter TOKENIZER = Splitter.onPattern((String)"\\s+");
    private Map<String, Vocab> itemrefVocabs;
    private Map<String, Vocab> itemVocabs;
    private Map<String, Vocab> metaVocabs;
    private Map<String, Vocab> linkVocabs;
    private Map<String, Vocab> linkrelVocabs;
    private final Deque<MetadataSet.Builder> metadataBuilders = Lists.newLinkedList();
    private MetadataSet metadata = null;
    private final Deque<LinkedResources.Builder> linkedResourcesBuilders = Lists.newLinkedList();
    private LinkedResources linkedResources = null;
    private final Deque<ResourceCollection.Builder> collectionBuilders = Lists.newLinkedList();
    private final ResourceCollections.Builder collectionsBuilder = ResourceCollections.builder();
    private ResourceCollections collections = null;

    OPFHandler30(ValidationContext context, XMLParser parser) {
        super(context, parser);
    }

    @Override
    public void startElement() {
        super.startElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if ("http://www.idpf.org/2007/opf".equals(e.getNamespace())) {
            if (name.equals("package")) {
                String prefixDecl = e.getAttribute("prefix");
                EPUBLocation loc = EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber());
                this.metaVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_META_VOCABS, KNOWN_META_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, loc);
                this.itemVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_ITEM_VOCABS, KNOWN_ITEM_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
                this.itemrefVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_ITEMREF_VOCABS, KNOWN_ITEMREF_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
                this.linkrelVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_LINKREL_VOCABS, KNOWN_LINKREL_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
                this.linkVocabs = VocabUtil.parsePrefixDeclaration(prefixDecl, RESERVED_LINK_VOCABS, KNOWN_LINK_VOCAB_URIS, DEFAULT_VOCAB_URIS, QuietReport.INSTANCE, loc);
            } else if (name.equals("metadata")) {
                this.metadataBuilders.addFirst(MetadataSet.builder());
                this.linkedResourcesBuilders.addFirst(LinkedResources.builder());
            } else if (name.equals("link")) {
                this.processLink(e);
            } else if (name.equals("item")) {
                String id = e.getAttribute("id");
                OPFItem.Builder itemBuilder = (OPFItem.Builder)this.itemBuilders.get(id);
                if (itemBuilder != null) {
                    this.processItemProperties(itemBuilder, e.getAttribute("properties"), e.getAttribute("media-type"));
                }
            } else if (name.equals("itemref")) {
                String idref = e.getAttribute("idref");
                OPFItem.Builder itemBuilder = (OPFItem.Builder)this.itemBuilders.get(idref);
                if (itemBuilder != null) {
                    this.processItemrefProperties(itemBuilder, e.getAttribute("properties"));
                }
            } else if (name.equals("mediaType")) {
                this.processBinding(e);
            } else if (name.equals("collection")) {
                this.collectionBuilders.addFirst(ResourceCollection.builder().roles(this.processCollectionRole(e.getAttribute("role"))));
                this.linkedResourcesBuilders.addFirst(LinkedResources.builder());
            }
        }
    }

    @Override
    public void endElement() {
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if ("http://www.idpf.org/2007/opf".equals(e.getNamespace())) {
            if (name.equals("package")) {
                this.collections = this.collectionsBuilder.build();
                for (ResourceCollection collection : this.getCollections().getByRole(ResourceCollection.Roles.INDEX)) {
                    this.processItemsInIndexCollection(collection);
                }
            } else if (name.equals("meta")) {
                this.processMeta(e);
            } else if (name.equals("metadata")) {
                LinkedResources linkedResources;
                MetadataSet metadata = null;
                try {
                    if (!this.metadataBuilders.isEmpty()) {
                        metadata = this.metadataBuilders.removeFirst().build();
                    }
                }
                catch (IllegalStateException ex) {
                    this.report.message(MessageId.OPF_065, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
                }
                LinkedResources linkedResources2 = linkedResources = this.linkedResourcesBuilders.isEmpty() ? null : this.linkedResourcesBuilders.removeFirst().build();
                if (this.collectionBuilders.isEmpty()) {
                    this.metadata = metadata;
                    this.linkedResources = linkedResources;
                    this.reportMetadata();
                } else {
                    this.collectionBuilders.peekFirst().metadata(metadata).metadataLinks(linkedResources);
                }
            } else if (name.equals("collection") && !this.collectionBuilders.isEmpty()) {
                if (!this.linkedResourcesBuilders.isEmpty()) {
                    this.collectionBuilders.peekFirst().resources(this.linkedResourcesBuilders.removeFirst().build());
                }
                ResourceCollection collection = this.collectionBuilders.removeFirst().build();
                if (this.collectionBuilders.isEmpty()) {
                    this.collectionsBuilder.add(collection);
                } else {
                    this.collectionBuilders.peekFirst().collection(collection);
                }
            }
        } else if ("http://purl.org/dc/elements/1.1/".equals(e.getNamespace())) {
            this.processDCElem(e);
        }
        super.endElement();
    }

    public MetadataSet getMetadata() {
        return this.metadata == null ? new MetadataSet.Builder().build() : this.metadata;
    }

    public LinkedResources getLinkedResources() {
        return this.linkedResources == null ? LinkedResources.builder().build() : this.linkedResources;
    }

    public ResourceCollections getCollections() {
        return this.collections == null ? ResourceCollections.builder().build() : this.collections;
    }

    private void processBinding(XMLElement e) {
        String mimeType = e.getAttribute("media-type");
        String handlerId = e.getAttribute("handler");
        if (mimeType != null && handlerId != null) {
            if (OPFChecker30.isCoreMediaType(mimeType)) {
                this.report.message(MessageId.OPF_008, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), mimeType);
                return;
            }
            if (this.context.xrefChecker.isPresent() && ((XRefChecker)this.context.xrefChecker.get()).getBindingHandlerId(mimeType) != null) {
                this.report.message(MessageId.OPF_009, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), mimeType, ((XRefChecker)this.context.xrefChecker.get()).getBindingHandlerId(mimeType));
                return;
            }
            if (this.itemBuilders.containsKey(handlerId) && this.context.xrefChecker.isPresent()) {
                ((XRefChecker)this.context.xrefChecker.get()).registerBinding(mimeType, handlerId);
            }
        }
    }

    private List<String> processCollectionRole(String roleAtt) {
        ImmutableList.Builder rolesBuilder = ImmutableList.builder();
        for (String role : TOKENIZER.split((CharSequence)Strings.nullToEmpty((String)roleAtt))) {
            if (role.matches("^[^:/?#]+://.*")) {
                try {
                    URI uri = new URI(role);
                    if (uri.getHost() != null && uri.getHost().contains("idpf.org")) {
                        this.report.message(MessageId.OPF_069, this.parser.getLocation(), role);
                        continue;
                    }
                    rolesBuilder.add((Object)role);
                }
                catch (URISyntaxException e) {
                    this.report.message(MessageId.OPF_070, this.parser.getLocation(), role);
                }
                continue;
            }
            if (ResourceCollection.Roles.fromString(role).isPresent()) {
                rolesBuilder.add((Object)role);
                continue;
            }
            this.report.message(MessageId.OPF_068, this.parser.getLocation(), role);
        }
        return rolesBuilder.build();
    }

    private void processLink(XMLElement e) {
        String href = e.getAttribute("href");
        if (href != null && !href.matches("^[^:/?#]+://.*")) {
            try {
                href = PathUtil.resolveRelativeReference(this.path, href);
            }
            catch (IllegalArgumentException ex) {
                this.report.message(MessageId.OPF_010, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href), ex.getMessage());
                href = null;
            }
        }
        if (href != null && href.matches("^[^:/?#]+://.*")) {
            this.report.info(this.path, FeatureEnum.REFERENCE, href);
        }
        if (this.context.xrefChecker.isPresent()) {
            ((XRefChecker)this.context.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.LINK);
        }
        if (!this.linkedResourcesBuilders.isEmpty()) {
            this.processLinkProperties(e.getAttribute("properties"));
            LinkedResource resource = new LinkedResource.Builder(href).id(e.getAttribute("id")).rel(this.processLinkRel(e.getAttribute("rel"))).mimetype(e.getAttribute("media-type")).refines(e.getAttribute("refines")).build();
            this.linkedResourcesBuilders.peekFirst().add(resource);
        }
    }

    private void processItemrefProperties(OPFItem.Builder builder, String property) {
        Set<Property> properties = VocabUtil.parsePropertyList(property, this.itemrefVocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        builder.properties(properties);
        if (properties.contains(RenditionVocabs.ITEMREF_VOCAB.get(RenditionVocabs.ITEMREF_PROPERTIES.LAYOUT_PRE_PAGINATED)) || !properties.contains(RenditionVocabs.ITEMREF_VOCAB.get(RenditionVocabs.ITEMREF_PROPERTIES.LAYOUT_REFLOWABLE)) && this.getMetadata().containsPrimary(RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.LAYOUT), "pre-paginated")) {
            builder.fixedLayout();
        }
    }

    private void processItemProperties(OPFItem.Builder builder, String property, String mimeType) {
        if (property == null) {
            return;
        }
        Set<Property> properties = VocabUtil.parsePropertyList(property, this.itemVocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        Set<PackageVocabs.ITEM_PROPERTIES> itemProps = Property.filter(properties, PackageVocabs.ITEM_PROPERTIES.class);
        mimeType = mimeType.trim();
        for (PackageVocabs.ITEM_PROPERTIES itemProp : itemProps) {
            if (itemProp.allowedOnTypes().contains(mimeType)) continue;
            this.report.message(MessageId.OPF_012, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), PackageVocabs.ITEM_VOCAB.getName(itemProp), mimeType);
        }
        builder.properties(properties);
    }

    private Set<Property> processLinkProperties(String properties) {
        return VocabUtil.parsePropertyList(properties, this.linkVocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
    }

    private Set<Property> processLinkRel(String rel) {
        Set<Property> linkRelProperties = VocabUtil.parsePropertyList(rel, this.linkrelVocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        if (Property.filter(linkRelProperties, PackageVocabs.LINKREL_PROPERTIES.class).contains(PackageVocabs.LINKREL_PROPERTIES.ALTERNATE) && linkRelProperties.size() > 1) {
            this.report.message(MessageId.OPF_089, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
        }
        return linkRelProperties;
    }

    private void processMeta(XMLElement e) {
        Optional<Property> prop = VocabUtil.parseProperty(e.getAttribute("property"), this.metaVocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        if (prop.isPresent() && !this.metadataBuilders.isEmpty()) {
            this.metadataBuilders.peekFirst().meta(e.getAttribute("id"), (Property)prop.get(), (String)e.getPrivateData(), e.getAttribute("refines"));
        }
        VocabUtil.parseProperty(e.getAttribute("scheme"), this.metaVocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
    }

    private void processDCElem(XMLElement e) {
        Optional<Property> prop = DCMESVocab.VOCAB.lookup(e.getName());
        if (prop.isPresent() && !this.metadataBuilders.isEmpty()) {
            this.metadataBuilders.peekFirst().meta(e.getAttribute("id"), (Property)prop.get(), (String)e.getPrivateData(), null);
        }
    }

    private void processItemsInIndexCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.INDEX) || collection.hasRole(ResourceCollection.Roles.INDEX_GROUP)) {
            for (LinkedResource resource : collection.getResources().asList()) {
                OPFItem.Builder itemBuilder = (OPFItem.Builder)this.itemBuildersByPath.get(resource.getPath());
                if (itemBuilder == null) continue;
                itemBuilder.properties((Set<Property>)ImmutableSet.of((Object)EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.IN_INDEX_COLLECTION)));
            }
            for (ResourceCollection childCollection : collection.getCollections().asList()) {
                this.processItemsInIndexCollection(childCollection);
            }
        }
    }

    protected void reportMetadata() {
        if (this.getMetadata().containsPrimary(RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.LAYOUT), "pre-paginated")) {
            this.report.info(null, FeatureEnum.HAS_FIXED_LAYOUT, "pre-paginated");
        }
    }

    @Override
    protected void reportItem(OPFItem item) {
        super.reportItem(item);
        boolean isFixed = this.getMetadata().containsPrimary(RenditionVocabs.META_VOCAB.get(RenditionVocabs.META_PROPERTIES.LAYOUT), "pre-paginated");
        if (item.getProperties().contains(RenditionVocabs.ITEMREF_VOCAB.get(RenditionVocabs.ITEMREF_PROPERTIES.LAYOUT_PRE_PAGINATED))) {
            isFixed = true;
        } else if (item.getProperties().contains(RenditionVocabs.ITEMREF_VOCAB.get(RenditionVocabs.ITEMREF_PROPERTIES.LAYOUT_REFLOWABLE))) {
            isFixed = false;
        }
        if (isFixed) {
            this.report.info(item.getPath(), FeatureEnum.HAS_FIXED_LAYOUT, String.valueOf(true));
        }
    }
}

