<p><img src="https://github.com/treasuryquants/examples/raw/main/assets/MainPic2.png" width="1100"></p>

***
# Python APIs
This is a set of examples in Python showing how to use our APIs. It covers all that we offer.

Before you start, the most important step is to ensure that you have an account. This is where most people get into issues. Contrary to most websites, you create your account using the API themselves. So all you need to open your account are these APIs, themselves. Just head straight to *TQ_example_account_create_account.py* to open your new account.

## 1. Open Your New Account
Once you opened your account you would have ample free credit in your account to get up the curve. Free top-ups will continue periodically to ensure those with small and moderate use will be able to use our services for free.
 

  
## 2. Getting around the python files
Here is a list of what you will find and a brief explanation of what each file is about.

### TQapis
| Files | Description |
| ------ | ----------- |
| TQConnection.py| This is the connection class that contains the HTTP protocol as well as the running account balance, etc.. |
| TQRequests.py | Contains all the functions that build the request parameters.  |
| TQResponse.py  | The Response class that consumes the response store in XML|


### test
| Files | Description |
| ------ | ----------- |
| TQUnitTest.py | Contains Runner Class which can be used to perform unit testing.  |

### python_examples
| Files | Description |
| ------ | ----------- |
| TQ_example_account_create_apis.py    | Shows the apis necessary to develop the account life cycle.  |
| TQ_example_describe.py    | Shows the way to list all our API functions and how to run them.|
| TQ_example_market_fx_rates.py    | Shows the steps of generating market spot FX and forward implied FX rates for a given date. |
| TQ_example_market_swap_rates.py | Shows the steps of generating market implied swap rates for a given date.|
| TQ_example_market_price.py | Shows the steps of pricing a save trade for a given date.|
| TQ_example_market_price_fx_forward.py | Shows the steps of pricing an fx forward for a given date.|
| TQ_example_market_price_vanilla_swap.py | Shows the steps of pricing a vanilla swap for a given date.|
| TQ_example_market_risk_ladder.py | Shows the steps of calculating the ladder sensitivities of a saved trade for a given date.|
| TQ_example_market_pnl_predict.py | Shows the steps of calculating the pnl predict of a saved trade between two dates.|
| TQ_example_market_pnl_attribute.py | Shows the steps of calculating the pnl attribute of a saved trade between two dates.|
| TQ_example_show_available.py | Shows list of all options available for each input data like business centers, day-count basis, etc.|
| TQ_example_workspace.py | Shows list of all the saved file and delete the one you ask.|

<a name="what_can_we_do_better"></a>
## What can we do better?
Any comments, feedback, question? just drop us a line.

<p align="left"><a href="https://treasuryquants.com/"> <img src="https://github.com/treasuryquants/examples/raw/main/assets/logoBlackSmall.png" width="300">
<p align="left">
Email: <a href="mailto:contact@treasuryquants.com">contact@treasuryquants.com</a><br>
Website: <a href="https://treasuryquants.com/" target="_blank">TreasuryQuants.com</a><br>
<p align="left"><a href="https://www.linkedin.com/company/treasury-quants/"><img src="https://github.com/treasuryquants/examples/raw/main/assets/linkedIn.png" width="35"></a></p>
