# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tfmake', 'tfmake.custom']

package_data = \
{'': ['*'], 'tfmake': ['templates/*']}

install_requires = \
['Jinja2>=2.11.1,<3.0.0',
 'PyYAML>=5.3.1,<6.0.0',
 'click>=7.0,<8.0',
 'outdated>=0.2.0,<0.3.0',
 'pathlib>=1.0.1,<2.0.0',
 'toml>=0.10.0,<0.11.0']

entry_points = \
{'console_scripts': ['tfmake = tfmake.cli:main']}

setup_kwargs = {
    'name': 'tfmake',
    'version': '1.0.4',
    'description': 'Python based Makefile wrapper for terraform projects',
    'long_description': '# tfmake\n\nThis is a Python based wrapper around an opionated `Makefile` I use for multi-cloud/cross-account `terraform` projects. \n\nYou still need `make`, though. The main advantage is that you don\'t have to copy the `Makefile`. \n\n## DISCLAIMER\nThis module includes a highly opinionated `Makefile` implementation. It\'s working very well for us, but your requirements might be different.\n\nAlso, I\'ve done my best to make this thing work on both MacOS and Linux. If you get an error message (~ and my colleagues haven\'t beat you to it) ... please get in touch and/or create a PR.\n\n## Install\n\n```\n$ pip install tfmake\n```\n\n## Usage\n> Here\'s the help for the wrapper\n```\n$ tfmake --help\nUsage: tfmake [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --version  Show the version and exit.\n  --help     Show this message and exit.\n\nCommands:\n  aws    Use AWS provider.\n  azure  Use Azure provider\n  guess  Default command that guesses what provider you\'re using.\n  init   Create configuration for provider.\n```\n\nA warning will be shown when your `tfmake` is out-of-date. If you see one, please update: `pip install --upgrade tfmake` \n\n## Providers\nCurrently, `tfmake` supports two providers: `aws` and `azure`. The default provider is `aws`. Depending on the selected provider, a different, provider specific, `Makefile` is used to wrap `terraform`. Here, the provider is selected by using the right command.\n\nSee \'examples\' for some ... examples.\n\nEach provider leads to a specific `Makefile`. For example: `provider==azure` leads to using `Makefile.azure`.\n\n## Provider Authentication\nThe used `Makefile` will _not_ handle authentication. It just assumes you\'re using an authenticated context.\n\nFor, `aws`, I use [`aws-vault`](https://github.com/99designs/aws-vault). For `azure`, I use the [`azure-cli`](https://docs.microsoft.com/en-us/cli/azure/install-azure-cli?view=azure-cli-latest).\n\n> Here\'s the help for the (bundled) Makefile\n```\n$ tfmake help\nThe AWS Edition\n\nUsage: make <TARGET> (env=<ENVIRONMENT>) (args=<TERRAFORM ARGUMENTS>)\n\nWhere:\n ENVIRONMENT is one of [\'dev\',\'tst\',\'acc\',\'prd\']\n TARGET is one:\n    update                          Update terraform modules and providers\n    select                          Select and initialize terraform workspace (aka \'stage\')\n    show                            Show current terraform workspace\n    plan                            Generate and show an execution plan\n    apply                           Builds or changes infrastructure\n    destroy                         Destroy Terraform-managed infrastructure\n    refresh                         Refresh terraform state\n\nNote:\n\n parameter \'env\' is only required when selecting an environment\n parameter \'args\' can be used to pass terraform understandable arguments. Example: "make apply args=\'-input=false -no-color -auto-approve\'"\n```\n\n> Use `tfmake azure help` to see the `azure` edition ...\n\n## Final Notes\n\nBy default, before any a `terraform` command is executed, you will be asked to confirm the usage of the current environment.\n\n```\n$ tfmake azure apply\n\nUsing workspace \'prd\' on \'My_fancy_Azure_Production_subscription\'.\n\nPress [ENTER] to continue or [CTRL-C] to stop.\n```\n\nPlease notice that the prompt shows the selected `terraform` workspace and the alias/name of the provider account.\n\n> Use `TFMAKE_AGREE=1` to auto confirm that prompt ...\n\n## Example\n\n> Initialise \'dev\' environment\n```\n$ aws-vault exec foobar -- tfmake select env=dev\n```\n\n> Plan changes\n```\n$ aws-vault exec foobar -- tfmake plan\n```\n\n> Apply changes\n```\n$ aws-vault exec foobar -- tfmake apply\n```\n\n> Apply changes using the `azure` provider\n```\n$ az login\n# (optionaly set subscription)\n$ az account set --subscription=YOUR_SUBSCRIPTION_ID_HERE\n$ tfmake azure apply\n```\n\n> Apply changes ... automagically\n```\n$ aws-vault exec foobar -- tfmake apply args=\'-no-color -auto-approve\'\n```\n\n**Note**: the `args` parameter can be used for arbitrary Terraform arguments.\n\n## Advanced Usage\n\nYou can use a _per_ project configuration file in which you can specify, for example, environment variables and/or arbitrary commands that need to be execute before or after the `make` target.\n\n```\n$ tfmake init aws\n\nConfiguration written to \'/your/current/directory/.tfmake\'\n```\n\n```\n---\n#\n# Welcome to the wonderful world of TFMAKE!\n#\n# This file is the main config file for your tfmake project.\n# It\'s very minimal at this point and uses default values.\n# You can always add more config options for more control.\n#\n# Happy Coding!\n#\nprovider: aws\n\n# You can define service wide environment variables here\n# Notes:\n# - when using commands, dont use single quotes (sorry)\n# - commands should be between $( and )\n#\n# environment:\n#    - variable1 = value\n#    - variable2 = $(command)\n\n# You can define commands here that are executed _before_ the Make target\n# Note: dont use single quotes (sorry)\n#\n# before:\n#    - echo "[INFO] before"\n\n# You can define commands here that are executed _after_ the Make target\n# Note: dont use single quotes (sorry)\n#\n# after:\n#    - echo "[INFO] after"%\n```\n\n#### Section `provider`\nThe `provider` section specifies what (default) provider to use for this project. As a result, you don\'t have to specify it anymore on the command-line.\n\nSo, no more `tfmake azure plan`. Instead, just configure the `provider` property and type `tfmake plan`.\n\n#### Section `environment`\nThe `environment` section can contain a list of environment variables that need to be set before calling the `make` target. \n\nFor example, when using the `azure` provider, you might want to dynamically fetch the value for the `ARM_SAS_TOKEN` or `ARM_ACCESS_KEY` from an Azure Key Vault.\n\n#### Section `before`\n\nThe `before` section can contain a list of commands that need to be executed preparing the call to the `make` target.\n\n#### Section `after`\n\nThe `after` section can contain a list of commands that you can use to cleanup after calling the `make` target.\n\n~ the end\n',
    'author': 'Pascal Prins',
    'author_email': 'pascal.prins@foobar-it.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/paprins/tfmake',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*, !=3.5.*, !=3.6.*',
}


setup(**setup_kwargs)
