from django import forms
from django.forms.widgets import Select, SelectMultiple


class AdminlteSelect(Select):
    template_name = "adminlte/widgets/select.html"

    def _get_media(self):
        return forms.Media(
            css={
                "all": ("admin/components/select2/dist/css/select2.min.css",)
            },
            js=(
                "admin/components/select2/dist/js/select2.min.js",
            ))

    media = property(_get_media)


class AdminlteSelectMultiple(SelectMultiple):
    template_name = "adminlte/widgets/select.html"

    def build_attrs(self, base_attrs, extra_attrs=None):
        extra_attrs['multiple'] = 'multiple'
        return {**base_attrs, **(extra_attrs or {})}

    def _get_media(self):
        return forms.Media(
            css={
                "all": ("admin/components/select2/dist/css/select2.min.css",)
            },
            js=(
                "admin/components/select2/dist/js/select2.min.js",
            ))

    media = property(_get_media)
