/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.entity;

import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.LabelName;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public interface WithLabels {
    public List<Label> getLabels();

    public void setLabels(List<Label> var1);

    default public <T> T findAll(LabelName name, Collector<String, ?, T> collector) {
        return this.findAll(name.value(), collector);
    }

    default public <T> T findAll(String name, Collector<String, ?, T> collector) {
        return this.getLabels().stream().filter(label -> name.equals(label.getName())).map(Label::getValue).collect(collector);
    }

    default public List<String> findAll(LabelName name) {
        return this.findAll(name, Collectors.toList());
    }

    default public List<String> findAll(String name) {
        return this.findAll(name, Collectors.toList());
    }

    default public Optional<String> findOne(LabelName name) {
        return this.findOne(name.value());
    }

    default public Optional<String> findOne(String name) {
        return this.getLabels().stream().filter(label -> name.equals(label.getName())).map(Label::getValue).findAny();
    }

    default public void addLabelIfNotExists(LabelName name, String value) {
        this.addLabelIfNotExists(name.value(), value);
    }

    default public void addLabelIfNotExists(String name, String value) {
        if (value == null || name == null) {
            return;
        }
        Optional<String> any = this.getLabels().stream().map(Label::getName).filter(name::equals).findAny();
        if (!any.isPresent()) {
            this.addLabel(name, value);
        }
    }

    default public void addLabel(String name, String value) {
        this.getLabels().add(new Label().setName(name).setValue(value));
    }
}

