##############################################################
### Radiko                                                 ###
### Copyright © 2020 kokarare1212 All rights reserved.     ###
###                                                        ###
### This software is released under the Apache License 2.0 ###
### see http://www.apache.org/licenses/LICENSE-2.0         ###
##############################################################

import defusedxml.ElementTree as ET
import base64, requests

class Radiko():

  version = "1.3.2"
  _auth1Url = "https://radiko.jp/v2/api/auth1"
  _auth2Url = "https://radiko.jp/v2/api/auth2"
  _streamUrl = "https://radiko.jp/v3/station/stream/aSmartPhone7o/"
  _fullStationUrl = "https://radiko.jp/v3/station/region/full.xml"
  _fullKey = "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"
  _locationList = {"JP1": [43.064615, 141.346807], "JP2": [40.824308, 140.739998], "JP3": [39.703619, 141.152684], "JP4": [38.268837, 140.8721], "JP5": [39.718614, 140.102364], "JP6": [38.240436, 140.363633], "JP7": [37.750299, 140.467551], "JP8": [36.341811, 140.446793], "JP9": [36.565725, 139.883565], "JP10": [36.390668, 139.060406], "JP11": [35.856999, 139.648849], "JP12": [35.605057, 140.123306], "JP13": [35.689488, 139.691706], "JP14": [35.447507, 139.642345], "JP15": [37.902552, 139.023095], "JP16": [36.695291, 137.211338], "JP17": [36.594682, 136.625573], "JP18": [36.065178, 136.221527], "JP19": [35.664158, 138.568449], "JP20": [36.651299, 138.180956], "JP21": [35.391227, 136.722291], "JP22": [34.97712, 138.383084], "JP23": [35.180188, 136.906565], "JP24": [34.730283, 136.508588], "JP25": [35.004531, 135.86859], "JP26": [35.021247, 135.755597], "JP27": [34.686297, 135.519661], "JP28": [34.691269, 135.183071], "JP29": [34.685334, 135.832742], "JP30": [34.225987, 135.167509], "JP31": [35.503891, 134.237736], "JP32": [35.472295, 133.0505], "JP33": [34.661751, 133.934406], "JP34": [34.39656, 132.459622], "JP35": [34.185956, 131.470649], "JP36": [34.065718, 134.55936], "JP37": [34.340149, 134.043444], "JP38": [33.841624, 132.765681], "JP39": [33.559706, 133.531079], "JP40": [33.606576, 130.418297], "JP41": [33.249442, 130.299794], "JP42": [32.744839, 129.873756], "JP43": [32.789827, 130.741667], "JP44": [33.238172, 131.612619], "JP45": [31.911096, 131.423893], "JP46": [31.560146, 130.557978], "JP47": [26.2124, 127.680932]}
  _stationList = ["HBC", "STV", "RN1", "RN2", "AIR-G", "NORTHWAVE", "HOUSOU-DAIGAKU", "JOIK", "JOAK-FM", "RAB", "AFB", "JOHK", "IBC", "FMI", "TBC", "DATEFM", "ABS", "AFM", "YBC", "RFM", "RFC", "FMF", "TBS", "QRR", "LFR", "INT", "FMT", "FMJ", "IBS", "JORF", "BAYFM78", "NACK5", "YFM", "JOAK", "CRT", "RADIOBERRY", "FMGUNMA", "BSN", "FMNIIGATA", "KNB", "FMTOYAMA", "JOCK", "MRO", "HELLOFIVE", "FBC", "FMFUKUI", "YBS", "FM-FUJI", "SBC", "FMN", "CBC", "TOKAIRADIO", "GBS", "ZIP-FM", "FMGIFU", "FMAICHI", "SBS", "K-MIX", "FMMIE", "ABC", "MBS", "OBC", "CCL", "802", "FMO", "KBS", "KISSFMKOBE", "E-RADIO", "JOBK", "ALPHA-STATION", "CRK", "WBS", "BSS", "FM-SANIN", "JOFK", "RSK", "FM-OKAYAMA", "RCC", "HFM", "KRY", "FMY", "JRT", "JOZK", "RNC", "FMKAGAWA", "RNB", "JOEU-FM", "RKC", "HI-SIX", "RKB", "KBC", "LOVEFM", "CROSSFM", "FMFUKUOKA", "JOLK", "FMS", "NBC", "FMNAGASAKI", "RKK", "FMK", "OBS", "FM_OITA", "MRT", "JOYFM", "MBC", "MYUFM", "RBC", "ROK", "FM_OKINAWA"]

  def getLiveStreamUrl(self, stationId):
    if not self._checkStation(stationId):
      raise RadikoException("Station not found")
    r = requests.get(self._streamUrl+stationId+".xml")
    r.raise_for_status()
    x = ET.fromstring(r.text)
    streamUrl = None
    for u in x:
      if u.attrib["areafree"] == "1" and u.attrib["timefree"] == "0" and not u[0].text.startswith("https://radiko.jp/"):
        streamUrl = u[0].text
        break
    if streamUrl is None:
      raise RadikoException("Failed to get stream url")
    return {
      "url": streamUrl+"?station_id="+stationId+"&l=15&lsid=&type=b",
      "authtoken": self._getAuthToken(self._getStationArea(stationId))
    }

  def getStreamUrl(self, stationId, ft, to):
    if not self._checkStation(stationId):
      raise RadikoException("Station not found")
    r = requests.get(self._streamUrl+stationId+".xml")
    r.raise_for_status()
    x = ET.fromstring(r.text)
    streamUrl = None
    for u in x:
      if u.attrib["areafree"] == "1" and u.attrib["timefree"] == "1":
        streamUrl = u[0].text
        break
    if streamUrl is None:
      raise RadikoException("Failed to get stream url")
    return {
      "url": streamUrl+"?station_id="+stationId+"&start_at="+ft+"&ft="+ft+"&end_at="+to+"&to="+to+"&l=15&lsid=&type=b",
      "authtoken": self._getAuthToken(self._getStationArea(stationId))
    }

  def getVersion(self):
    return self.version

  def isStationAvailable(self, stationId):
    r = requests.get(self._fullStationUrl)
    x = ET.fromstring(r.text)
    for es in x.findall("stations"):
      for e in es.findall("station"):
        if e.find("id").text == stationId:
          return True
    return False

  def getAvailableStations(self):
    s = []
    r = requests.get(self._fullStationUrl)
    x = ET.fromstring(r.text)
    for es in x.findall("stations"):
      for e in es.findall("station"):
        s.append(e.find("id").text)
    return s

  def _checkStation(self, stationId):
    return stationId in self._stationList

  def _getStationArea(self, stationId):
    r = requests.get(self._fullStationUrl)
    x = ET.fromstring(r.text)
    for es in x.findall("stations"):
      for e in es.findall("station"):
        if e.find("id") == stationId:
          return e.find("area_id").text

  def _getAuthToken(self, regionId):
    r1 = requests.get(self._auth1Url, headers={
      "X-Radiko-App": "aSmartPhone7o",
      "X-Radiko-App-Version": "0.0.1",
      "X-Radiko-User": "dummy_user",
      "X-Radiko-Device": "Python.Radiko",
    })
    r1.raise_for_status()
    authToken = r1.headers["X-Radiko-AuthToken"]
    keyLength = int(r1.headers["X-Radiko-KeyLength"])
    keyOffset = int(r1.headers["X-Radiko-KeyOffset"])
    partialKey = base64.b64encode(base64.b64decode(self._fullKey)[keyOffset:keyOffset+keyLength])
    r2 = requests.get(self._auth2Url, headers={
      "X-Radiko-App": "aSmartPhone7o",
      "X-Radiko-App-Version": "0.0.1",
      "X-Radiko-User": "dummy_user",
      "X-Radiko-Device": "Python.Radiko",
      "X-Radiko-AuthToken": authToken,
      "X-Radiko-PartialKey": partialKey,
      "X-Radiko-Connection": "wifi",
      "X-Radiko-Location": str(self._locationList[regionId][0])+","+str(self._locationList[regionId][1])+",gps",
    })
    r2.raise_for_status()
    return authToken

class RadikoException(Exception):
  pass
