<p align="center">
  <img width="200" src="https://user-images.githubusercontent.com/42001064/120057695-b1f6c680-c062-11eb-96d5-2c43d05f9018.png" alt="logo">
  <h1 align="center" style="margin: 0 auto 0 auto;">Tkinter Designer</h1>
  <h5 align="center" style="margin: 0 auto 0 auto;">Automate Tkinter GUI Creation</h5>
  </p>

  <p align="center">
    <img src="https://img.shields.io/github/last-commit/ParthJadhav/Tkinter-Designer">
    <img src="https://img.shields.io/github/contributors/ParthJadhav/Tkinter-Designer">
    <img src="https://img.shields.io/github/issues/ParthJadhav/Tkinter-Designer?label=issues">
    <img src="https://img.shields.io/github/stars/ParthJadhav/Tkinter-Designer">
  </p>

  <br>

## Translations
- [简体中文](/docs/README.zh-CN.md)
- [Français](/docs/README.fr-FR.md)
- [ગુજરાતી](/docs/README.gu-GU.md)

___ 

## 💡 Introduction
Tkinter Designer was created to speed up the GUI development process in Python. It uses the well-known design software [Figma](https://www.figma.com/) to make creating beautiful Tkinter GUIs in Python a piece of cake 🍰.

Tkinter Designer uses the Figma API to analyse a design file and create the respective code and files needed for the GUI. Even Tkinter Designer's GUI is created using Tkinter Designer.

<img width="500" alt="Tkinter Designer GUI" src="https://user-images.githubusercontent.com/42001064/119863796-92af4a80-bf37-11eb-9f6c-61b1ab99b039.png">

## ☄️  Advantages of Tkinter Designer
1. Drag and drop interfaces
2. Significantly faster than creating code manually
3. Ability to create more beautiful interfaces

___

## 🦋 Supporting Tkinter Designer

Life without coffee is like something without something … sorry, I haven’t had any coffee yet. 

<a href="https://www.buymeacoffee.com/Parthjadhav" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/arial-yellow.png" alt="Buy Me A Coffee" width="217px" ></a> 


## ⚡️ Installing & Using Tkinter Designer

The instructions contain all the information about installing and using Tkinter Designer, along with information for troubleshooting and reporting issues. There is also a video.

### [Read the Instructions](/docs/instructions.md)
### [Watch the Video](https://youtu.be/mFjE2-rbpm8)  

___
<br>

## 🔵 Join Official Tkinter Designer's Discord server

Click the button below to join the discord server and take part in discussions. 

<a href="https://discord.gg/QfE5jMXxJv" target="_blank"><img src="https://user-images.githubusercontent.com/42001064/126635148-9a736436-5a6d-4298-8d8e-acda11aec74c.png" alt="Join Discord Server" width="217px" ></a> 


## ✅  Importance of Naming (mentioned in the [video](https://youtu.be/mFjE2-rbpm8) and [instructions](/docs/instructions.md))

Tkinter Designer heavily depends on names of the elements to convert it to code. See the naming guide [here](/docs/instructions.md#2-element-guide).
___
<br>

## 📐 How it Works
The only thing the user needs to do is design an interface with Figma, and then paste the Figma file URL and API token into Tkinter Designer.

Tkinter Designer will automatically generate all the code and images required to create the GUI in Tkinter.

<img width="467" alt="How it Works" src="https://user-images.githubusercontent.com/42001064/119832620-fb88c980-bf1b-11eb-8e9b-4affe7b92ba2.jpg">

___
<br>

## 🎯 Examples
The possibilities are endless with Tkinter Designer, but here are a couple of GUIs that can be perfectly replicated in Tkinter.

<sup>The following are not my creations.</sup>

### Registration Page
<img width="467" alt="Example 1" src="https://user-images.githubusercontent.com/42001064/119250338-1f1adf80-bbbd-11eb-8ee1-72028a4e7a7f.png">

### Branding Page
<img width="467" alt="Example 2" src="https://user-images.githubusercontent.com/42001064/119250668-496d9c80-bbbf-11eb-886b-cb1e75da18df.png">

### Frame Recorder [(More Info)](https://github.com/mehmet-mert/FrameRecorder)
<img width="467" alt="Example 3" src="https://user-images.githubusercontent.com/42001064/119834287-71d9fb80-bf1d-11eb-9acf-e7bfc8cc4d9e.png">

### WhatBulk  [(More Info)](https://www.instagram.com/p/CQUmKckFBbT/?utm_medium=copy_link)
<img width="467" alt="Example 3" src="https://user-images.githubusercontent.com/42001064/122562284-87e06500-d060-11eb-8257-55f3b9dbecf0.PNG">


## 🔥 Showcase
If your app was made with Tkinter Designer, let me know. It will be helpful for others to see more examples!  
(See: [Contact Me](#-contact-me)) or use [Show and Tell](https://github.com/ParthJadhav/Tkinter-Designer/discussions/categories/show-and-tell) section in Discussions.

___
<br>
 

## 📝 Contact Me

If you want to contact me, you can reach me at Jadhavparth99@gmail.com

___
<br>

## 📄 License
<!--- If you're not sure which open license to use see https://choosealicense.com/--->

Tkinter Designer is licensed under the BSD 3-Clause "New" or "Revised" License.  
[View Here.](https://github.com/ParthJadhav/Tkinter-Designer/blob/master/LICENSE)

| Permissions | Restrictions | Conditions
| --- | --- | --- 
&check; Commercial Use | &times; Liability | &#x1f6c8; License and Copyright Notice
&check; Modification   | &times; Warranty
&check; Distribution  
&check; Private Use
