import os
os.environ['PYGAME_HIDE_SUPPORT_PROMPT'] = "hide"
import math
import ctypes
import requests
import sys
#sys.stderr=open("stderr.txt", "w")
import traceback
import atexit
import subprocess
import pickle
import pyperclip
import wx
import sound_lib
from sound_lib import stream, output
from threading import Thread
from accessible_output2 import outputs
screenReader=outputs.auto.Auto()
import pygame
o=output.Output()
mainStarted=False
isWindowActive=False
isGameWindowActive=isWindowActive
keysPressed={}
showAlert=False
showQuestion=False
showInput=False
keepResponding=True
changeWindowName=False
hideWindowName=False
from pygame.locals import *
app=wx.App()
def exit():
	os._exit(1)
atexit.register(exit)
def fileExists(fileName):
	return os.path.isfile(fileName)
def dirCreate(dirName):
	os.mkdir(dirName)
def dirExists(dirName):
	return os.path.isdir(dirName)
def showWindow(windowName):
	global changeWindowName
	changeWindowName=windowName
def question(title, message):
	global showQuestion
	showQuestion={"title": title, "message": message}
	while not showQuestion==False: wait(5)
	if answer==wx.ID_YES: return 1
	elif answer==wx.ID_NO: return 2
	elif answer==wx.ID_CANCEL: return 3
	else: return 0
def inputBox(title, message, defaultValue=""):
	alert("Error", "This function isn't available at the moment.")
	return
	global showInput
	showInput={"title": title, "message": message, "defaultValue": defaultValue}
	while not showInput==False: wait(5)
	return textTyped
def alert(title, message, block=True):
	global showAlert
	showAlert={"title": title, "message": message}
	if block:
		while not showAlert==False: wait(5)
def hideWindow():
	global hideWindowName
	hideWindowName=True
def backWindow():
	global hideWindowName
	hideWindowName="back"
showGameWindow=showWindow
hideGameWindow=hideWindow
backGameWindow=backWindow
def run(program, args=None, wait=True, background=True):
	p=subprocess.Popen(program, args, shell=background==False)
	if wait: p.wait()
def isAdmin():
	try:
		is_admin=os.getuid()==0
	except AttributeError:
		is_admin=ctypes.windll.shell32.IsUserAnAdmin()!=0
	return is_admin
class timer:
	def __init__(self, paused=True):#paused by default
		self.paused=paused
		self.pausedTime=0
		if self.paused==False: self.start()
	def start(self):
		self.paused=False
		self.pausedTime=0
		self.initialTime=pygame.time.get_ticks()
	@property
	def time(self):
		if self.paused: return self.pausedTime
		return self.pausedTime+pygame.time.get_ticks()-self.initialTime
	elapsed=time
	def pause(self):
		self.pausedTime=self.time
		self.paused=True
	def resume(self):
		self.initialTime=pygame.time.get_ticks()
		self.paused=False
class vector:
	def __init__(self, x=0.0, y=0.0, z=0.0):
		self.x=x; self.y=y; self.z=z

class sound:
	def __init__(self):
		self.handle=None
		self.freq=44100
		self.paused=False

	def load(self,sample=None):
		if self.handle:
			self.close()

		self.handle =stream.FileStream(file=sample)
		self.freq=self.handle.get_frequency()

	def play(self):
		self.handle.looping=False
		self.handle.play()

	def pause(self):
		if self.paused: return
		if not self.playing: return
		self.handle.pause()
		self.paused=True

	def resume(self):
		if self.playing: return
		self.handle.play()
		self.paused=False

	def setPaused(self,p):
		if self.paused==p: return
		if not self.playing and p: return
		self.paused=p
		if p:
			self.handle.pause()
		else:
			self.handle.play()

	def playLogo(self, skipKey=K_RETURN):
		self.skiped=False
		self.play()
		while self.playing:
			if keyPressed(skipKey):
				self.skiped=True
				self.stop()
			wait(5)

	def playWait(self, looping=False):
		self.handle.looping=looping
		self.handle.play_blocking()

	def playLooped(self):
		self.handle.looping=True
		self.handle.play()

	def stop(self):
		if self.handle and self.handle.is_playing:
			self.handle.stop()
			self.handle.set_position(0)

	def fadeOut(self, fadeTime):
		if self.handle and self.handle.is_playing:
			self.handle.slide_attribute("volume", 0, fadeTime//1000)

	def speakerTest(self, time=3000):
		if self.handle and self.handle.is_playing:
			self.pan=-100
			self.handle.slide_attribute("pan", 1, time//1000)

	@property
	def volume(self):
		if not self.handle:
			return False
		return round(math.log10(self.handle.volume)*20)
	@volume.setter
	def volume(self,value):
		if not self.handle:
			return False
		self.handle.set_volume(10**(float(value)/20))

	@property
	def pitch(self):
		if not self.handle:
			return False
		return (self.handle.get_frequency()/self.freq)*100

	@pitch.setter
	def pitch(self, value):
		if value>400: value=400
		if not self.handle:
			return False
		self.handle.set_frequency((float(value)/100)*self.freq)

	@property
	def pan(self):
		if not self.handle:
			return False
		return self.handle.get_pan()*100

	@pan.setter
	def pan(self, value):
		if not self.handle:
			return False
		self.handle.set_pan(float(value)/100)

	@property
	def playing(self):
		if self.handle is None:
			return False
		try:
			s=self.handle.is_playing
		except BassError:
			return False
		return s

	def close(self):
		if self.handle:
			self.handle.free()

def loadSound(fileName):
	s=sound()
	s.load(fileName)
	return s
class basicSound:
	def __init__(self, path, pan=0):
		self.path=path
		if not pygame.mixer.get_init():
			pygame.mixer.init()
			pygame.mixer.set_num_channels(500)
		self.__obj=pygame.mixer.Sound(path)
		self.channel=pygame.mixer.find_channel()
		self.pan=pan
	def playLooped(self, loops=-1):
		self.channel.play(self.__obj, loops=loops)
	def playWait(self, loops=0):
		self.channel.play(self.__obj, loops=loops)
		while self.channel.get_busy():
			wait(5)
	def playLogo(self, skipKey=K_RETURN, loops=0):
		self.skiped=False
		self.channel.play(self.__obj, loops=loops)
		while self.channel.get_busy():
			if keyPressed(skipKey):
				self.skiped=True
				self.channel.stop()
			wait(5)
	@property
	def pan(self):
		return self.__pan
	@pan.setter
	def pan(self, pan):
		if pan<-100: pan=-100
		if pan>100: pan=100
		self.__pan=pan
		if pan<0 and pan>=-100:
			self.channel.set_volume(1, 1+pan/100)
		elif pan>0 and pan<=100:
			self.channel.set_volume(1-pan/100, 1)
	def play(self, loops=0):
		self.channel.play(self.__obj, loops=loops)
	def stop(self):
		self.channel.stop()
	def pause(self):
		self.channel.pause()
	def resume(self):
		self.channel.unpause()
class gameMenu:
	def __init__(self, intro=None, introSound=None, wrap=False, escape=True, enterSound=None, clickSound=None, itens=[]):
		self.intro=intro
		self.introSound=introSound
		self.wrap=wrap
		self.escape=escape
		self.enterSound=enterSound
		self.clickSound=clickSound
		if not self.clickSound==None: self.__clickObj=pygame.mixer.Sound(self.clickSound)
		self.itens=itens
	def show(self):
		self.selection=None; self.actualSelection=1
		if not self.introSound==None:
			self.__soundObj=pygame.mixer.Sound(self.introSound)
			self.soundChannel=self.__soundObj.play()
			while self.soundChannel.get_busy(): wait(5)
		if not self.intro==None:
			out(self.intro)
		if os.path.isfile(self.itens[0]):
			self.currentSound=basicSound(self.itens[0])
			self.currentChannel=self.currentSound.play()
		else:
			out(self.itens[0])
		while self.selection==None:
			if self.escape and keyPressed(K_ESCAPE):
				self.selection=0
			self.down=keyPressed(K_DOWN);self.up=keyPressed(K_UP)
			if self.down and not self.clickSound==None or self.up and not self.clickSound==None:
				self.__clickObj.stop()
				self.__clickObj.play()
			if self.down:
				if not self.actualSelection>=len(self.itens): self.actualSelection+=1
				else:
					if self.wrap: self.actualSelection=1
				if os.path.isfile(self.itens[self.actualSelection-1]):
					self.currentSound.stop()
					self.currentSound=basicSound(self.itens[self.actualSelection-1])
					self.currentChannel=self.currentSound.play()
				else:
					out(self.itens[self.actualSelection-1], interrupt=True)
			if self.up:
				if not self.actualSelection<=1: self.actualSelection-=1
				else:
					if self.wrap: self.actualSelection=len(self.itens)
				if os.path.isfile(self.itens[self.actualSelection-1]):
					self.currentSound.stop()
					self.currentSound=basicSound(self.itens[self.actualSelection-1])
					self.currentChannel=self.currentSound.play()
				else:
					out(self.itens[self.actualSelection-1], interrupt=True)
			if keyPressed(K_RETURN):
				self.selection=self.actualSelection
				self.selectionName=self.itens[self.selection-1]
				if not self.enterSound==None:
					self.__enterObj=pygame.mixer.Sound(self.enterSound)
					self.__enterObj.play()
			if self.selection==0:
				self.selectionName=""
			wait(5)
	def add(self, item):
		if isinstance(item, str):
			self.itens.append(item)
		if isinstance(item, list):
			for individualItem in item:
				self.itens.append(individualItem)
def keyPressed(keyCode):
	return keysPressed.pop(keyCode, False)
def keyDown(keyCode):
	return keysDown[keyCode]
def forceScreenReader(screenReaderName):
	global screenReader
	if screenReaderName=="nvda":
		screenReader=outputs.nvda.NVDA()
	elif screenReaderName=="jaws":
		screenReader=outputs.jaws.Jaws()
	elif screenReaderName=="window_eyes":
		screenReader=outputs.window_eyes.WindowEyes()
	elif screenReaderName=="system_access":
		screenReader=outputs.system_access.SystemAccess()
	elif screenReaderName=="sapi4":
		screenReader=outputs.sapi4.Sapi4()
	elif screenReaderName=="sapi5":
		screenReader=outputs.sapi5.SAPI5()
	else:
		screenReader=outputs.auto.Auto()
def updateScreenReader():
	global screenReader
	screenReader=outputs.auto.Auto()
def silence():
	outputs.nvda.NVDA().silence()
def speak(msg, interrupt=False):
	msg=str(msg)
	screenReader.speak(msg, interrupt=interrupt)
def out(msg, interrupt=False):
	msg=str(msg)
	if isinstance(screenReader, outputs.sapi5.SAPI5):
		speak(msg, interrupt=interrupt)
	else:
		screenReader.output(msg, interrupt=interrupt)
cbReadText=pyperclip.paste
cbCopyText=pyperclip.copy
def urlGet(url):
	return str(requests.get(url).content)
def serialize(dict, file):
	pickle.dump(dict, open(file, "wb"))
def deserialize(file):
	return pickle.load(open(file, "rb"))
def positionSound1d(sound, listenerX, sourceX, panStep=1, volumeStep=1):
	positionSoundCustom1d(sound, listenerX, sourceX, panStep=panStep, volumeStep=volumeStep, startPan=0.0, startVolume=0.0)
def positionSoundCustom1d(sound, listenerX, sourceX, panStep=1, volumeStep=1, startPan=0.0, startVolume=0.0):
	finalPan=startPan
	finalVolume=startVolume
	if sourceX<listenerX:
		delta=listenerX-sourceX
		finalPan-=delta*panStep
		finalVolume-=delta*volumeStep
	elif sourceX>listenerX:
		delta=sourceX-listenerX
		finalPan+=delta*panStep
		finalVolume-=delta*volumeStep
	if finalPan>100: finalPan=100
	elif finalPan<-100: finalPan=-100
	if finalVolume>100: finalVolume=100
	elif finalVolume<-100: finalVolume=-100
	if not sound.pan==finalPan:
		sound.pan=finalPan
	if not sound.volume==finalVolume:
		sound.volume=finalVolume
def positionSound2d(sound, listenerX, sourceX, listenerY, sourceY, panStep=1, volumeStep=1, pitchStep=1):
	positionSoundCustom2d(sound, listenerX, sourceX, listenerY, sourceY, panStep=panStep, volumeStep=volumeStep, pitchStep=pitchStep, startPan=0.0, startVolume=0.0, startPitch=100.0)
def positionSoundCustom2d(sound, listenerX, sourceX, listenerY, sourceY, panStep=1, volumeStep=1, pitchStep=1, startPan=0.0, startVolume=0.0, startPitch=100.0):
	finalPan=startPan
	finalVolume=startVolume
	finalPitch=startPitch
	if sourceX<listenerX:
		delta=listenerX-sourceX
		deltaY=listenerY-sourceY
		finalPan-=delta*panStep
		finalVolume-=delta*volumeStep
		finalPitch-=deltaY*pitchStep
	elif sourceX>listenerX:
		delta=sourceX-listenerX
		deltaY=sourceY-listenerY
		finalPan+=delta*panStep
		finalVolume-=delta*volumeStep
		finalPitch-=deltaY*pitchStep
	if finalPan>100: finalPan=100
	elif finalPan<-100: finalPan=-100
	if finalVolume>100: finalVolume=100
	elif finalVolume<-100: finalVolume=-100
	if finalPitch>400: finalPitch=400
	elif finalPitch<10: finalPitch=10
	if not sound.pan==finalPan:
		sound.pan=finalPan
	if not sound.volume==finalVolume:
		sound.volume=finalVolume
	if not sound.pitch==finalPitch:
		sound.pitch=finalPitch
def waitKey(keyCode=K_RETURN):
	while not keyPressed(keyCode): wait(5)
def wait(ms=5):
	pygame.time.wait(ms)
def exHandler(type, ex, tb):
	line=str(tb.tb_lineno)
	exType=type.__name__
	exDescript=str(ex)
	alert("python BGT runtime error", "an error occurred on line "+line+". \n"+exType+": "+exDescript)
	exit()
sys.excepthook=exHandler

def main():
	pygame.init()
	pygame.fastevent.init()
	screen=pygame.display.set_mode()
	pygame.display.set_caption("python BGT window")
	global keysDown
	global keysPressed
	global changeWindowName
	global mainStarted
	global hideWindowName
	global showAlert
	global showQuestion
	global showInput
	global textTyped
	global answer
	global isWindowActive
	keysDown=pygame.key.get_pressed()
	mainStarted=True
	while True:
		if isinstance(showAlert, dict):
			dial=wx.MessageDialog(None, showAlert["message"], showAlert["title"], wx.OK|wx.ICON_INFORMATION)
			dial.ShowModal()
			dial.Destroy()
			showAlert=False
		if isinstance(showQuestion, dict):
			quest=wx.MessageDialog(None, showQuestion["message"], showQuestion["title"], wx.YES_NO|wx.CANCEL|wx.ICON_QUESTION)
			answer=quest.ShowModal()
			quest.Destroy()
			showQuestion=False
		if isinstance(showInput, dict):
			inputFrame=wx.Frame(None, title="python BGT")
			input=wx.TextEntryDialog(inputFrame, showInput["message"], showInput["title"])
#			input.SetValue(showInput["defaultValue"])
			textTyped=input.ShowModal()
			input.Destroy()
			showInput=False
		if not changeWindowName==False:
			pygame.display.set_caption(changeWindowName)
			changeWindowName=False
		if hideWindowName==True:
			pygame.display.set_mode(flags=HIDDEN)
			hideWindowName=False
		if hideWindowName=="back":
			pygame.display.set_mode()
			hideWindowName=False
		if keepResponding:
			pygame.display.update()
			for evt in pygame.fastevent.get():
				if evt.type==pygame.QUIT:
					os._exit(1)
				if evt.type==pygame.KEYDOWN:
					keysPressed[evt.key]=True
				if evt.type==pygame.KEYUP:
					keysPressed.pop(evt.key, None)
		keysDown=pygame.key.get_pressed()
		isWindowActive=pygame.display.get_active()
		wait(5)
mainThread=Thread(target=main)
mainThread.daemon=True
mainThread.start()
while not mainStarted: wait(5)