import click

from ..utils import CONTEXT_SETTINGS
from .notebook import monitor_sync, start_notebook, stop_notebook


@click.group(name="notebook-beta", context_settings=CONTEXT_SETTINGS)
def notebook():
    """Commands for managing JupyterLab sessions on dedicated VMs in the cloud.

    NOTE: notebooks are an experimental feature, and may change or be removed
    without warning.

    The Python packages you have installed locally are automatically installed.
    (See https://docs.coiled.io/user_guide/package_sync.html for details.)

    Your local filesystem can also be synced using the `--sync` flag.

    This creates an easy "make my laptop bigger" command, since you'll have
    the same files and environment, just on a bigger machine in the cloud.
    """
    pass


notebook.add_command(start_notebook, "up")
notebook.add_command(stop_notebook, "down")
notebook.add_command(monitor_sync, "monitor")
